*
* ICMP SUPPORT
*
ICMPMINLEN EQU 8 ; MINIMUM LENGTH FOR ICMP
*
* ICMP MESSAGE TYPES
*
ICMPUNREACH EQU 3 ; DESTINATION UNREACHABLE
ICMPQUENCH EQU 4 ; SOURCE QUENCH
ICMPREDIRECT EQU 5 ; REDIRECT
ICMPECHO EQU 8 ; ECHO
ICMPTIMXCEED EQU 11 ; TIME EXCEEDED
ICMPPARAMPROB EQU 12 ; PARAMETER PROBLEM
*
ICMPMAXTYPE EQU 18 ; MAXIMUM TYPE CODE
*
ICMPLEN DS 2 ; TOTAL LENGTH OF ICMP DATAGRAM
*
* THE FOLLOWING CODE IS MAINLY INTENDED FOR DESTINATION
* UNREACHABLE ERRORS PASSED TO THE SOCKETS CODE.
ICMPERR DFB 0 ; ICMP ERROR CODE
*
* USED FOR ICMPERROR
ICMPERRTYPE DFB 0
ICMPERRCODE DFB 0
*
*
*
* HANDLEICMP
*
* BASIC OVERVIEW OF HOW ICMP ERROR HANDLING WORKS:
* 1.) THIS ROUTINE GETS PROTOCOL FROM ATTACHED IP HEAD
* 2.) PROTOCOLS'S ICMP ERROR HANDLER IS CALLED
* 3.) ERROR HANDLER FINDS RESPONSIBLE SOCKET (IF ANY)
* 4.) IF SOCKET FOUND, ICMP ERROR CODE STORED FOR THAT SOCKET
* 5.) NEXT CALL TO SEND/RECV CHECKS AND RETURNS ERROR CODE.
*
HANDLEICMP
* COMPUTE ICMP LENGTH
 LDY #3 ; LOW-BYTE IP LENGTH
 SEC
 LDA (INPBUF),Y
 SBC IPHEADLEN
 STA ICMPLEN
 DEY  ; HIGH-BYTE
 LDA (INPBUF),Y
 SBC #0
 STA ICMPLEN+1
*
* MESSAGE TOO SHORT?
*
 LDA ICMPLEN+1
 BNE :NEXT
 LDA ICMPLEN
 CMP #ICMPMINLEN ; TOO SHORT?
 BCS :NEXT ; OK
* MESSAGE WAS TOO SHORT
 CLC  ; SILENT DISCARD
 RTS
:NEXT
 CLC
 LDA INPBUF ; ADVANCE THE POINTER
 ADC IPHEADLEN ; ...20 BYTES TO THE ICMP DATA
 STA INPBUF
 LDA INPBUF+1
 ADC #0
 STA INPBUF+1
*
* VERIFY ICMP CHECKSUM
*
 LDA ICMPLEN
 STA CHKSUMLEN
 LDA ICMPLEN+1
 STA CHKSUMLEN+1
 LDA INPBUF
 STA PTR2
 LDA INPBUF+1
 STA PTR2+1
 CLC
 JSR UDPCHKSUM2
 ORA CHKSUM+1 ; A-REG ALREADY LOADED
 BEQ :CHECKSUMOK
* BAD CHECKSUM
 DO DEBUG
 LDA #"@"
 JSR COUT
 FIN
 CLC  ; SILENT DISCARD
 RTS
:CHECKSUMOK
 DO DEBUG
 LDA #"+"
 JSR COUT
* PRINT THE ICMP TYPE
 LDA #" "
 JSR COUT
 LDY #0
:L LDA MSG10,Y
 BEQ :NEXT2
 JSR COUT
 INY
 BNE :L
 FIN
:NEXT2 LDY #0 ; POINT TO ICMP TYPE
 LDA (INPBUF),Y
 CMP #ICMPMAXTYPE+1 ; WITHIN LIMITS?
 BCC :TYPEOK
 CLC  ; SILENT DISCARD
 RTS
:TYPEOK
 DO DEBUG
 JSR PRBYTE ; A IS SCRAMBLED AFTERWARD
 LDA (INPBUF),Y
 FIN
 BEQ :ECHOREPLY
 CMP #ICMPUNREACH
 BEQ :DESTUNREACH
 CMP #ICMPREDIRECT
 BEQ :REDIRECT
 CMP #ICMPECHO
 BEQ :ECHO
*
* PUT CHECKS FOR ADDITIONAL TYPES HERE.
* RFC 1122: UNKNOWN TYPES ARE SILENTLY DISCARDED.
:ECHOREPLY
:REDIRECT
 RTS
*
*
* DESTINATION UNREACHABLE. FIND OUT EXACTLY WHAT IS WRONG
* BY LOOKING AT THE CODE. RFCS 792 AND 1122 HAVE THESE.
:DESTUNREACH
 INY ; POINT TO CODE
 LDA (INPBUF),Y
 LDX #$30 ; HIGH NYBBLE IS DEST UNREACH
 STX ICMPERR
 ORA ICMPERR ; PUT CODE IN LOW NYBBLE
 STA ICMPERR ; AND NOW WE HAVE OUR ERR CODE
* FIND WHICH SOCKET THIS BELONGS TO AND REPORT ERROR.
 LDY #17 ; PROTOCOL
 LDA (INPBUF),Y
 CMP #17 ; UDP?
 BNE :CHECKTCP
* ADVANCE INPBUF AND LOOK UP SOCKET
 CLC
 LDA INPBUF
 ADC #4 ; SKIP ICMP HEAD
 STA INPBUF
 LDA INPBUF+1
 ADC #0
 STA INPBUF+1
* SKIP IP HEAD
 LDY #0
 LDA (INPBUF),Y
 AND #%00001111
 ASL
 ASL
 CLC
 ADC INPBUF
 STA INPBUF
 LDA INPBUF+1
 ADC #0
 STA INPBUF+1
 JSR UDPICMPERR ; FIND THE GUILTY SOCKET
 BCS :UNREACHDONE ; NO MATCHING SOCKET
* SOCKET FOUND, ID IS IN A-REG
 PHA ; SAVE FOR DEBUG
 JSR PRBYTE
 LDA #$8D
 JSR COUT
 PLA ; DEBUG RESTORE
 JSR SOGETSOBYID ; ASSUME SUCCESS
* STORE ERROR CODE IN SOCKET TABLE
 LDA ICMPERR
 STA SOTABERR,X
 RTS ; ALL DONE!
:CHECKTCP
:UNREACHDONE
 RTS
*
*
* ECHO REQUEST. ANSWERING BROADCAST ECHO REQUESTS IS OPTIONAL.
*
:ECHO
 INY ; POINT TO CODE
 LDA (INPBUF),Y
 BNE :ECHODONE ; CODE MUST BE ZERO
*
* IF WE WANT TO IGNORE BROADCAST ECHOS, ADD A CHECK
* FOR BCASTFLAG HERE:
* LDA BCASTFLAG
* BNE :ECHODONE
*
 DEY ; POINT BACK TO TYPE
 STA (INPBUF),Y ; TYPE 0 = ECHO REPLY
*
* ADJUST CHECKSUM
*
 CLC
 INY
 INY ; POINT TO ICMP CHKSUM
 LDA (INPBUF),Y
 ADC #ICMPECHO
 STA (INPBUF),Y
 INY
 LDA (INPBUF),Y
 ADC #0
 STA (INPBUF),Y
*
* PREPARE TO SEND
*
 LDA INPBUF
 STA OUTPBUF
 LDA INPBUF+1
 STA OUTPBUF+1
 LDA ICMPLEN
 STA OUTPLEN
 LDA ICMPLEN+1
 STA OUTPLEN+1
* IP DESTINATION
 LDY #33
 LDX #3
:CDL LDA IPINSRC,X
 STA OUTPHEAD,Y
 DEY
 DEX
 BPL :CDL
* SEND IT
 JMP ICMPSEND2
:ECHODONE
 RTS
*
*
* ICMP ERROR
*
* SEND AN ICMP ERROR DATAGRAM IN RESPONSE TO AN IP
* DATAGRAM.
* CALLER NEEDS TO STORE ICMP TYPE AND CODE IN
* ICMPERRTYPE AND ICMPERRCODE, RESPECTIVELY.
* IPHEAD MUST POINT TO THE OFFENDING IP DATAGRAM;
* THIS POINTER WILL BE COPIED TO PTR.
*
ICMPERROR
 LDA IPHEAD
 STA PTR
 LDA IPHEAD+1
 STA PTR+1
* DON'T SEND ERROR IF NOT FIRST FRAGMENT
 LDY #6 ; POINT TO IP FLAGS
 LDA (PTR),Y
 AND #%00011111 ; MASK FLAGS
 INY  ; POINT TO FRAGMENT OFFSET
 ORA (PTR),Y
 BNE :ERRDONE ; NOT FIRST FRAGMENT
* DON'T SEND ERROR FOR ICMP DATAGRAMS
 LDY #9 ; POINT TO IP PROTOCOL
 LDA (PTR),Y
 CMP #PROTOICMP
 BEQ :ERRDONE ; IT'S AN ICMP DGRAM
* DON'T SEND ERROR FOR BROADCAST DATAGRAMS
 LDA BCASTFLAG
 BNE :ERRDONE
*
* TODO: DON'T SEND ERROR FOR MULTICAST DATAGRAMS
*
* TODO: COMPUTE ICMP LENGTH
* THIS SHOULD BE THE LENGTH OF THE ORIGINAL IP
* HEAD + 8 + ICMPMINLEN (USUALLY TOTALLING 36)
*
 LDA #36 ; ASSUME 36 BYTES FOR NOW
 STA ICMPLEN
 STA OUTPLEN
 LDA #0
 STA ICMPLEN+1
 STA OUTPLEN+1
*
* CHECK ICMP TYPE
*
 LDA ICMPERRTYPE
 CMP #ICMPMAXTYPE+1 ; TYPE WITHIN RANGE?
 BCS :ERRDONE
 STA ICMPERRBUF ; STORE TYPE
 TAX  ; SAVE FOR LATER
 LDA ICMPERRCODE
 STA ICMPERRBUF+1 ; STORE CODE
*
* CHECK IF WE NEED TO ZERO THE UNUSED SECTION
* IN CASE OF AN UNREACHABLE OR TIME EXCEEDED ERROR
*
 CPX #ICMPUNREACH
 BEQ :ZEROUNUSED
 CPX #ICMPTIMXCEED
 BNE :COPYIPHEAD
:ZEROUNUSED
 LDA #0
 LDX #3
:ZL STA ICMPERRBUF+4,X
 DEX
 BPL :ZL
*
* COPY OLD IP HEADER TO ICMP MESSAGE
*
:COPYIPHEAD
 LDY #19 ; COPY 20 BYTES
:L LDA (PTR),Y
 STA ICMPERRBUF+8,Y
 DEY
 BPL :L
*
* COPY 8 BYTES OF IP PAYLOAD
*
 CLC
 LDA IPHEADLEN
 ADC PTR
 STA PTR
 LDA PTR+1
 ADC #0
 STA PTR+1
 LDY #7 ; COPY 8 BYTES
:L2 LDA (PTR),Y
 STA ICMPERRBUF+28,Y
 DEY
 BPL :L2
*
* SET DESTINATION IP ADDRESS
* TO SRC ADDRESS
*
 LDY #33
 LDX #3
:L3 LDA IPINSRC,X
 STA OUTPHEAD,Y
 DEY
 DEX
 BPL :L3
*
* PREPARE TO SEND
*
 LDA #<ICMPERRBUF
 STA OUTPBUF
 STA PTR2 ; FOR CHECKSUM
 LDA #>ICMPERRBUF
 STA OUTPBUF+1
 STA PTR2+1
*
* SEND IT
*
 JMP ICMPSEND
*
* AND WE'RE DONE
*
:ERRDONE
 RTS
*
*
* ICMP ERROR MESSAGE BUFFER
*
* 36 BYTES IS ENOUGH SPACE FOR MANY, BUT NOT ALL, OF
* THE ICMP ERROR MESSAGE TYPES THAT COULD BE SENT.
* THIS WILL WORK FOR:
*  - DEST UNREACH
*  - TIME EXCEED
*  - PARAM PROB
*  - SRC QUENCH
*  - REDIRECT
* ...AND A FEW OTHERS. IT IS EXPECTED THAT ONLY
* DEST UNREACH MESSAGES WILL BE SENT. IF THAT TURNS
* OUT NOT TO BE THE CASE, THEN THIS BUFFER CAN BE
* ENLARGED IF MORE SPACE IS NEEDED.
*
ICMPERRBUF DS 36
*
*
*
* ICMP SEND
*
* COMPUTE ICMP CHECKSUM AND FORWARD TO IP LAYER
* PTR2 MUST POINT TO ICMP MESSAGE.
* ICMPLEN MUST HOLD LENGTH OF ICMP MESSAGE.
*
ICMPSEND
 LDA ICMPLEN
 STA CHKSUMLEN
 LDA ICMPLEN+1
 STA CHKSUMLEN+1
 LDA #0
 LDY #2 ; POINT TO CHECKSUM FIELD
 STA (PTR2),Y ; CLEAR CHECKSUM
 INY
 STA (PTR2),Y
 JSR UDPCHKSUM2 ; COMPUTE ICMP CHECKSUM
 LDY #2
 STA (PTR2),Y ; STORE LOW-BYTE OF CHKSUM
 INY
 LDA CHKSUM+1
 STA (PTR2),Y
*
* ALTERNATE ENTRY POINT FOR ECHO REPLIES
*
ICMPSEND2
*
* SELECT SOURCE ADDRESS
*
 LDA #1
 LDY #26
 STA OUTPHEAD,Y
*
* IP HEAD
*
 LDA #0
 STA OUTPHLEN ; NO OTHER PROTOCOL HEADERS
 LDY #16 ; IP LENGTH
 STA OUTPHEAD,Y
 INY
 STA OUTPHEAD,Y
 INY  ; IP ID
 STA OUTPHEAD,Y
 INY
 STA OUTPHEAD,Y
 LDY #22 ; IP TTL
 STA OUTPHEAD,Y
 INY  ; IP PROTOCOL
 LDA #PROTOICMP
 STA OUTPHEAD,Y
*
* SEND TO IP LAYER
*
 JSR IPPREP
 JMP IPSEND
